const Joi = require("joi");
const enquirySchema = Joi.object({
  fullname: Joi.string().min(3).max(30).required(),
  email: Joi.string()
    .email()
    .regex(/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/)
    .required(),
  contact: Joi.string()
    .min(10)
    .max(10)
    .regex(/^[789]\d{9}$/)
    .required(),
  state: Joi.string().required(),
  city: Joi.string().required(),
  investment: Joi.number().required(),
  message: Joi.string().required(),
  created_at: Joi.date().default(Date.now),
});

const contactSchema = Joi.object({
  name: Joi.string().min(3).max(30).required(),
  email: Joi.string()
    .email()
    .regex(/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/)
    .required(),
    mobile: Joi.string()
    .min(10)
    .max(10)
    .regex(/^[789]\d{9}$/)
    .required(),
    created_at: Joi.date().default(Date.now),
});

function validateEnquiry(req, res, next) {
  const { error, value } = enquirySchema.validate(req.body);
  

  if (error) {
    return res.status(400).json({
      status: "error",
      message: error.details.map((err) => err.message),
    });
  }
  next();
}

function validateContact(req, res, next) {
    const { error, value } = contactSchema.validate(req.body);

    if(error){
        return res.status(400).json({
            status: "error",
            message: error.details.map((err) => err.message),
        });
    }
    next();
}



module.exports = {
  validateEnquiry,
  validateContact,
};
